﻿using System;
using System.Collections.Generic;
using System.Linq;
using BllDalLib.DAL;

namespace BllDalLib.BLL
{
    public class HospitalManager
    {
        public List<HospitalStaff> GetDoctors()
        {
            using (var staffCtx = new HospitalDataContext())
            {
                return
                    (from staff in staffCtx.HospitalStaffs
                     where staff.Position == "Doctor"
                     select staff)
                     .ToList();
            }
        }

        private List<string> positions = new List<string>
        {
            "Doctor", "Nurse", "Intern1", "Intern2"
        };

        public void AddStaff(string name, string position)
        {
            if (!positions.Contains(position))
            {
                throw new ArgumentException("Invalid Position!", "position");
            }

            using (var staffCtx = new HospitalDataContext())
            {
                staffCtx
                    .HospitalStaffs
                    .InsertOnSubmit
                    (
                        new HospitalStaff
                        {
                            Name = name,
                            Position = position
                        }
                    );

                staffCtx.SubmitChanges();
            }
        }
    }
}
